unload to "/dev/null"
select
        n1.n_name,
        sum(l_extendedprice * (1 - l_discount)) as revenue
from
        customer,
        orders,
        lineitem,
        supplier,
        nation n1,
        nation n2,
        region r1,
        region r2
where
        c_custkey = o_custkey
        and l_orderkey = o_orderkey
        and l_suppkey = s_suppkey
        and c_nationkey = n1.n_nationkey
        and s_nationkey = n2.n_nationkey
        and n1.n_regionkey = r1.r_regionkey
        and n2.n_regionkey = r2.r_regionkey
        and r1.r_name = 'ASIA'
        and o_orderdate >= DATE('1994-01-01')
        and o_orderdate < DATE('1994-01-01') + 1 UNITS year
group by
        n_name
order by
        revenue desc;
